#include <stdio.h>
#include "interfaces.h"
#include "vga_pixel.h"
#include "aud.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

int get_aud_data(const int aud_fd) {
	aud_arg_t aat;
	if (ioctl(aud_fd, AUD_READ_DATA, &aat)) {
		perror("ioctl(AUD_READ_DATA) failed");
		return 0;
	}
	return aat.memory.data;
}

int get_angle_data(const int aud_fd) {
        aud_arg_t aat;
        if (ioctl(aud_fd, ANGLE_READ_DATA, &aat)) {
                perror("ioctl(ANGLE_READ_DATA) failed");
                return 0;
        }
        return aat.memory.data;
}


